﻿Public Class Form1

    REM Diese Testroutine ist speziell für unseren Leser FS-2044 ausgelegt.
    REM Sie soll zeigen wie man unter Visual Basic 2017 ein ComPort
    REM öffnet und Daten vom Leser anzeigt.
    REM Mit den drei Buttons kann die LED Rot EIN und AUS geschaltet werde.
    REM Bzw. der Beeper für eine Sekunde aktiviert werden.
    REM
    REM Josef Rohrmüller FS-Fertigungsservice, 
    REM
    REM eMail: Josef.Rohrmueller@FSJR.de
    REM Internet: WWW.easyident.de
    REM



    Public MyBaudrate = "9600"      REM  Speichervariable für die benbötigte Baudrate
    Public RxBuffer As String       REM  Speichervariable für Empfangene RS232 Daten
    Public TxBuffer As String       REM  Speichervariable für zu sendende RS232 Daten
    Public MyComPort As String      REM  Speichervariable für das ausgewählte COM-Port



    REM ----------------- Hauptroutine! -----------------------------------
    REM Diese Routine wird nach dem Programmstart ausgeführt!                    

    Private Sub Main_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        GetFreeComPort()                REM Sucht alle freien COM-Ports am System und zeigt sie an.

        Timer1.Interval = 200           REM Setzt Timerinterval auf 200 ms
        Timer1.Enabled = True           REM Timer1 Freigeben.
        CloseComPort.Visible = False    REM Button CloseComPort ausblenden, da noch kein ComPort offen ist.
        Label1.Visible = True           REM Label1 Anzeigen
        LedRotOn.Visible = False        REM Button LedRotON ausblenden.
        LedRotOff.Visible = False       REM Button LEDRotOff ausblenden.
        Beep1Sekunde.Visible = False    REM Button Beep 1 Sekunde ausblenden.
    End Sub

    REM ------------------ Verfügbare COM-Port auflisten. -----------------------------
    REM Sucht alle freien COM-Ports am Rechner und zeigt sie in der ListComPorts an.

    Sub GetFreeComPort()
        Dim MyError As Boolean                  REM Variable für Fehlermeldung
        Dim ComPort As String = ""              REM Variable für ComPort

        ListComPorts.Visible = True             REM ListComPorts Anzeigen
        ListComPorts.Items.Clear()              REM Inhalt löschen
        SerialPort1.Close()                     REM Comport schließen falls offen!
        For Each ComPort In My.Computer.Ports.SerialPortNames   REM Alle ComPorts auflisten
            SerialPort1.PortName = ComPort.ToString
            Try
                SerialPort1.Open()              REM Prüfen ob ComPort zu öffnen ist
            Catch ex As Exception
                MyError = True
            End Try
            If MyError = False Then
                SerialPort1.Close()             REM ComPort schließen
                ListComPorts.Items.Add(ComPort) REM PortName in die Liste aufnehmen.
            End If
        Next
        CloseComPort.Visible = False            REM Button CloseComPort ausblenden!
    End Sub

    REM ---------------- Wird aus der ListComPorts ein COM-Port ausgewählt,
    REM ---------------- wird diese Routine ausgeführt und das COM-Port geöffnet.

    Private Sub ListComPorts_SelectedIndexChanged(sender As Object, e As EventArgs) Handles ListComPorts.SelectedIndexChanged

        MyComPort = ListComPorts.SelectedItem           REM Ausgewähltes COM-Port speichern
        If MyComPort = "" Then
            Exit Sub
        End If
        SerialPort1.Close()                             REM falls ein Comport offen wäre wird es geschlossen.
        SerialPort1.PortName = MyComPort                REM COM-Port festlegen. (Ausgewältes COM-Port)
        SerialPort1.BaudRate = MyBaudrate               REM Baudrate festlegen. (9600)
        SerialPort1.DataBits = 8                        REM Anzahl der Datenbits festlegen (8)
        SerialPort1.Parity = IO.Ports.Parity.None       REM Parity festlenen (None)
        SerialPort1.StopBits = IO.Ports.StopBits.One    REM StopBits festlegen. (1)
        SerialPort1.Handshake = IO.Ports.Handshake.None REM Handshake festlegen. (None)
        SerialPort1.ReceivedBytesThreshold = 1          REM Ereignis festlegen. (Nach jedem Zeichen wird ein Ereignis geliefert)

        Try                                             REM Fehlermeldung abfangen. 
            SerialPort1.Open()                          REM SerialPort öffnen!
        Catch ex As Exception                           REM Ist ein Fehler ausgetreten?
            MsgBox("Kann Serial Port nicht öffnen.")    REM Fehlermeldung Anzeigen.
            Exit Sub                                    REM Im Fehlerfall beenden.
        End Try
        SerialPort1.DtrEnable = False                   REM Data Terminal Readready Signal auf Low setzen.
        SerialPort1.RtsEnable = False                   REM Request to Send Signal auf Low setzen.

        Timer1.Start()                                  REM Timer Starten. 
        '                                               REM Die Timerroutine holt die Zeichen von der Schnitstelle ab.
        CloseComPort.Visible = True                     REM Button CloseComPort anzeigen.
        Label1.Visible = False                          REM Label1  nicht anzeigen. 
        LedRotOn.Visible = True                         REM Button LedRedON anzeigen
        LedRotOff.Visible = True                        REM Button LEDRedOff anzeigen
        Beep1Sekunde.Visible = True                     REM Button Beep1Sekunde Anzeigen
        ListComPorts.Visible = True                     REM ListBox ListComPorts nicht mehr anzeigen.
    End Sub

    REM -------------- Timer1 Routine -----------------------------
    REM -------------- Holt die Zeichen von der RS232 Schnittstelle ab.

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        If SerialPort1.IsOpen Then                      REM Nur abholen wenn COMPort offen ist!
            RxBuffer = SerialPort1.ReadExisting         REM Alle verfügbaren Zeichen abholen.
            RX_Textbox.AppendText(RxBuffer)             REM Zeichen in der Textbox anzeigen.
        End If
    End Sub

    REM -------------- LED rot einschalten. ------------------------
    REM
    Private Sub LedRotOn_Click(sender As Object, e As EventArgs) Handles LedRotOn.Click
        TxBuffer = "led,0,red,1,#crc" + vbCr            REM TxBuffer mit dem Kommando füllen.
        SerialPort1.Write(TxBuffer)                     REM Daten an der RS232 ausgeben.
    End Sub

    REM -------------- Beeper 1e Sekunde aktivieren. ----------------
    REM

    Private Sub Beep1Selkunde_Click(sender As Object, e As EventArgs) Handles Beep1Sekunde.Click
        TxBuffer = "beep,0,1000,#crc" + vbCr            REM TxBuffer mit dem Kommando füllen.
        SerialPort1.Write(TxBuffer)                     REM Daten an der RS232 ausgeben.
    End Sub

    REM ---------------- Close COMPort -----------------------------
    REM
    Private Sub CloseComPort_Click(sender As Object, e As EventArgs) Handles CloseComPort.Click
        SerialPort1.Close()                             REM Schließt das geöffnete Comport!
        Label1.Visible = True                           REM Label1 sichtbar
        LedRotOn.Visible = False                        REM Button LEDRotOn nicht anzeigen.
        LedRotOff.Visible = False                       REM Button LedRotOff nicht anzeigen.
        Beep1Sekunde.Visible = False                    REM Button Beep 1e Sekunde nicht anzeigen.
        CloseComPort.Visible = False
        GetFreeComPort()

    End Sub

    REM --------------- LED rot ausschalten. -------------------------
    REM
    Private Sub LedredOff_Click(sender As Object, e As EventArgs) Handles LedRotOff.Click
        TxBuffer = "led,0,red,0,#crc" + vbCr            REM TxBuffer mit dem Kommando füllen.
        SerialPort1.Write(TxBuffer)                     REM Daten an der RS232 ausgeben.
    End Sub
End Class
